{**********************************************************************
{*
{* Darts Globals -- Version 3.0  (interface)
{*
{* Copyright (c)
{* Apple Computer, Inc.  1986-1990
{* All Rights Reserved.
{*
{* Developer Technical Support Apple II Sample Code
{*
{* Written by Steven E. Glass
{*
{* This file contains the global variables used by the 
{* program.
{*
{**********************************************************************}
UNIT uGlobals;

INTERFACE

USES	

		types,
		locator,
		memory,
		quickdraw,
		intMath,
		events,
		controls,
		windows,
		dialogs,
		STDFile,
		lists;

const

	AppleMenuID				= $1100;
		AboutItem			= $1101;
	FileMenuID				= $1200;
		NewItem				= $1202;
		QuitItem			= $1203;
	EditMenuID				= $1300;
		UndoItem			= 250;    {For DA's}
		CutItem				= 251;    {For DA's}
		CopyItem			= 252;    {For DA's}
		PasteItem			= 253;    {For DA's}
		ClearItem			= 254;    {For DA's}
	GameMenuID				= $1400;
		RobinGameItem 		= $1401;
		CrickettGameItem 	= $1402;
		   
	NumPlayers = 2;
	Player1 = 1;
	Player2 = 2;

	RobinWindow 	= $1000;
	CrickettWindow 	= $1001;

	ConfirmTextID 	= 2;
	
type

	theMemRecHndl = ^theMemRecPtr;
	theMemRecPtr = ^theMemRec;
	theMemRec = PACKED RECORD
		memPtr : Ptr; { Pointer to string, or custom }
		memFlag : integer; { Bit Flag }
	end;
	
	ListArrayHandle = ^ListArrayPtr;
	ListArrayPtr = ^ListArray;
	ListArray = packed array [0..0] of theMemRec;		
	
var
	crickettTables 	: array[1..NumPlayers,1..26] of integer;
	score 			: array[1..NumPlayers] of integer;
	listEntries 	: array[1..NumPlayers] of integer;

	userID, 
	gameType		: integer;
	
	weHaveAWinner, 
	quitFlag, 
	firstUpdateComplete : boolean; 


	scoreList		: array[1..NumPlayers] of ListArrayHandle;
	event 			: WmTaskRec;
	theWindow 		: GrafPortPtr;

	scoreStrings 	: array[1..NumPlayers] of Str255;
	scoreStringArray : array[0..1] of StringPtr;

	blankStr,
	oneStr,
	twoStr,
	threeStr 		: string[1];
	   
procedure InitGlobals;                                     {Setup variables}

IMPLEMENTATION

{$i uGlobals.inc.p}

END.
